@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.AdditionalUnattendContentArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ComponentNames
import com.pulumi.azurenative.compute.kotlin.enums.PassNames
import com.pulumi.azurenative.compute.kotlin.enums.SettingNames
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
 * @property componentName The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
 * @property content Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
 * @property passName The pass name. Currently, the only allowable value is OobeSystem.
 * @property settingName Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
 */
public data class AdditionalUnattendContentArgs(
    public val componentName: Output<ComponentNames>? = null,
    public val content: Output<String>? = null,
    public val passName: Output<PassNames>? = null,
    public val settingName: Output<SettingNames>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.AdditionalUnattendContentArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.AdditionalUnattendContentArgs =
        com.pulumi.azurenative.compute.inputs.AdditionalUnattendContentArgs.builder()
            .componentName(componentName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .content(content?.applyValue({ args0 -> args0 }))
            .passName(passName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .settingName(settingName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AdditionalUnattendContentArgs].
 */
@PulumiTagMarker
public class AdditionalUnattendContentArgsBuilder internal constructor() {
    private var componentName: Output<ComponentNames>? = null

    private var content: Output<String>? = null

    private var passName: Output<PassNames>? = null

    private var settingName: Output<SettingNames>? = null

    /**
     * @param value The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
     */
    @JvmName("gxmuqnrvbnplgbcv")
    public suspend fun componentName(`value`: Output<ComponentNames>) {
        this.componentName = value
    }

    /**
     * @param value Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
     */
    @JvmName("hxslduesbyxrsxng")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The pass name. Currently, the only allowable value is OobeSystem.
     */
    @JvmName("bqebrfbrccfaftte")
    public suspend fun passName(`value`: Output<PassNames>) {
        this.passName = value
    }

    /**
     * @param value Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
     */
    @JvmName("egoadtguxujunrqc")
    public suspend fun settingName(`value`: Output<SettingNames>) {
        this.settingName = value
    }

    /**
     * @param value The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
     */
    @JvmName("arkcxywuerymtmqh")
    public suspend fun componentName(`value`: ComponentNames?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
     */
    @JvmName("ynvgvhtyoexqvwhg")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The pass name. Currently, the only allowable value is OobeSystem.
     */
    @JvmName("qdgxbtuatvmcoxdu")
    public suspend fun passName(`value`: PassNames?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passName = mapped
    }

    /**
     * @param value Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
     */
    @JvmName("yjjxavhyxpmxweqk")
    public suspend fun settingName(`value`: SettingNames?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingName = mapped
    }

    internal fun build(): AdditionalUnattendContentArgs = AdditionalUnattendContentArgs(
        componentName = componentName,
        content = content,
        passName = passName,
        settingName = settingName,
    )
}
