@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the role profile for the cloud service.
 * @property roles List of roles for the cloud service.
 */
public data class CloudServiceRoleProfileArgs(
    public val roles: Output<List<CloudServiceRoleProfilePropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs.builder()
            .roles(
                roles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudServiceRoleProfileArgs].
 */
@PulumiTagMarker
public class CloudServiceRoleProfileArgsBuilder internal constructor() {
    private var roles: Output<List<CloudServiceRoleProfilePropertiesArgs>>? = null

    /**
     * @param value List of roles for the cloud service.
     */
    @JvmName("kyjitfreqmsxrlvq")
    public suspend fun roles(`value`: Output<List<CloudServiceRoleProfilePropertiesArgs>>) {
        this.roles = value
    }

    @JvmName("ajuxtwkpgitdavkp")
    public suspend fun roles(vararg values: Output<CloudServiceRoleProfilePropertiesArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values List of roles for the cloud service.
     */
    @JvmName("fhockyyliajqpmpy")
    public suspend fun roles(values: List<Output<CloudServiceRoleProfilePropertiesArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value List of roles for the cloud service.
     */
    @JvmName("ftjojqsauhfxinty")
    public suspend fun roles(`value`: List<CloudServiceRoleProfilePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the cloud service.
     */
    @JvmName("geldtrvqyadbpdpp")
    public suspend
    fun roles(argument: List<suspend CloudServiceRoleProfilePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CloudServiceRoleProfilePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the cloud service.
     */
    @JvmName("tonmookrrfbkwkss")
    public suspend fun roles(
        vararg
        argument: suspend CloudServiceRoleProfilePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CloudServiceRoleProfilePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the cloud service.
     */
    @JvmName("kgikmnjhyhavqrdb")
    public suspend
    fun roles(argument: suspend CloudServiceRoleProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CloudServiceRoleProfilePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values List of roles for the cloud service.
     */
    @JvmName("huyejdpgsruiepve")
    public suspend fun roles(vararg values: CloudServiceRoleProfilePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): CloudServiceRoleProfileArgs = CloudServiceRoleProfileArgs(
        roles = roles,
    )
}
