@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceVaultCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role instance.
 * @property certificateUrl This is the URL of a certificate that has been uploaded to Key Vault as a secret.
 */
public data class CloudServiceVaultCertificateArgs(
    public val certificateUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceVaultCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceVaultCertificateArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceVaultCertificateArgs.builder()
            .certificateUrl(certificateUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudServiceVaultCertificateArgs].
 */
@PulumiTagMarker
public class CloudServiceVaultCertificateArgsBuilder internal constructor() {
    private var certificateUrl: Output<String>? = null

    /**
     * @param value This is the URL of a certificate that has been uploaded to Key Vault as a secret.
     */
    @JvmName("ycmqvohcsknjijgg")
    public suspend fun certificateUrl(`value`: Output<String>) {
        this.certificateUrl = value
    }

    /**
     * @param value This is the URL of a certificate that has been uploaded to Key Vault as a secret.
     */
    @JvmName("aralufprjaxycvcl")
    public suspend fun certificateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateUrl = mapped
    }

    internal fun build(): CloudServiceVaultCertificateArgs = CloudServiceVaultCertificateArgs(
        certificateUrl = certificateUrl,
    )
}
