@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CopyCompletionErrorArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CopyCompletionErrorReason
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
 * @property errorCode Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
 * @property errorMessage Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
 */
public data class CopyCompletionErrorArgs(
    public val errorCode: Output<Either<String, CopyCompletionErrorReason>>,
    public val errorMessage: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CopyCompletionErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CopyCompletionErrorArgs =
        com.pulumi.azurenative.compute.inputs.CopyCompletionErrorArgs.builder()
            .errorCode(
                errorCode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .errorMessage(errorMessage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopyCompletionErrorArgs].
 */
@PulumiTagMarker
public class CopyCompletionErrorArgsBuilder internal constructor() {
    private var errorCode: Output<Either<String, CopyCompletionErrorReason>>? = null

    private var errorMessage: Output<String>? = null

    /**
     * @param value Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("elhrxvowkudbdqix")
    public suspend fun errorCode(`value`: Output<Either<String, CopyCompletionErrorReason>>) {
        this.errorCode = value
    }

    /**
     * @param value Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("tsdrbpxhmxfrnyfo")
    public suspend fun errorMessage(`value`: Output<String>) {
        this.errorMessage = value
    }

    /**
     * @param value Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("rsgyuciieqspcwxl")
    public suspend fun errorCode(`value`: Either<String, CopyCompletionErrorReason>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("kipggfaystuwtjld")
    public fun errorCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CopyCompletionErrorReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("ebmslstlweojlyyu")
    public fun errorCode(`value`: CopyCompletionErrorReason) {
        val toBeMapped = Either.ofRight<String, CopyCompletionErrorReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
     */
    @JvmName("qbheuqaxjyadocko")
    public suspend fun errorMessage(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorMessage = mapped
    }

    internal fun build(): CopyCompletionErrorArgs = CopyCompletionErrorArgs(
        errorCode = errorCode ?: throw PulumiNullFieldException("errorCode"),
        errorMessage = errorMessage ?: throw PulumiNullFieldException("errorMessage"),
    )
}
