@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CreationDataArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiskCreateOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Data used when creating a disk.
 * @property createOption This enumerates the possible sources of a disk's creation.
 * @property galleryImageReference Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
 * @property imageReference Disk source information for PIR or user images.
 * @property logicalSectorSize Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
 * @property performancePlus Set this flag to true to get a boost on the performance target of the disk deployed, see here on the respective performance target. This flag can only be set on disk creation time and cannot be disabled after enabled.
 * @property securityDataUri If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
 * @property sourceResourceId If createOption is Copy, this is the ARM id of the source snapshot or disk.
 * @property sourceUri If createOption is Import, this is the URI of a blob to be imported into a managed disk.
 * @property storageAccountId Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
 * @property uploadSizeBytes If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
 */
public data class CreationDataArgs(
    public val createOption: Output<Either<String, DiskCreateOption>>,
    public val galleryImageReference: Output<ImageDiskReferenceArgs>? = null,
    public val imageReference: Output<ImageDiskReferenceArgs>? = null,
    public val logicalSectorSize: Output<Int>? = null,
    public val performancePlus: Output<Boolean>? = null,
    public val securityDataUri: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val sourceUri: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val uploadSizeBytes: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CreationDataArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CreationDataArgs =
        com.pulumi.azurenative.compute.inputs.CreationDataArgs.builder()
            .createOption(
                createOption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .galleryImageReference(
                galleryImageReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logicalSectorSize(logicalSectorSize?.applyValue({ args0 -> args0 }))
            .performancePlus(performancePlus?.applyValue({ args0 -> args0 }))
            .securityDataUri(securityDataUri?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .sourceUri(sourceUri?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .uploadSizeBytes(uploadSizeBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreationDataArgs].
 */
@PulumiTagMarker
public class CreationDataArgsBuilder internal constructor() {
    private var createOption: Output<Either<String, DiskCreateOption>>? = null

    private var galleryImageReference: Output<ImageDiskReferenceArgs>? = null

    private var imageReference: Output<ImageDiskReferenceArgs>? = null

    private var logicalSectorSize: Output<Int>? = null

    private var performancePlus: Output<Boolean>? = null

    private var securityDataUri: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var sourceUri: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var uploadSizeBytes: Output<Double>? = null

    /**
     * @param value This enumerates the possible sources of a disk's creation.
     */
    @JvmName("bjharscahsypygbw")
    public suspend fun createOption(`value`: Output<Either<String, DiskCreateOption>>) {
        this.createOption = value
    }

    /**
     * @param value Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
     */
    @JvmName("jjecuiqhbjmusvxo")
    public suspend fun galleryImageReference(`value`: Output<ImageDiskReferenceArgs>) {
        this.galleryImageReference = value
    }

    /**
     * @param value Disk source information for PIR or user images.
     */
    @JvmName("onckxmbjbtdajtls")
    public suspend fun imageReference(`value`: Output<ImageDiskReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
     */
    @JvmName("smhsircqfxskegol")
    public suspend fun logicalSectorSize(`value`: Output<Int>) {
        this.logicalSectorSize = value
    }

    /**
     * @param value Set this flag to true to get a boost on the performance target of the disk deployed, see here on the respective performance target. This flag can only be set on disk creation time and cannot be disabled after enabled.
     */
    @JvmName("qkskkkvjqgatdwho")
    public suspend fun performancePlus(`value`: Output<Boolean>) {
        this.performancePlus = value
    }

    /**
     * @param value If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
     */
    @JvmName("hplvqqmwmudgeook")
    public suspend fun securityDataUri(`value`: Output<String>) {
        this.securityDataUri = value
    }

    /**
     * @param value If createOption is Copy, this is the ARM id of the source snapshot or disk.
     */
    @JvmName("tnykishvwfeafphs")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value If createOption is Import, this is the URI of a blob to be imported into a managed disk.
     */
    @JvmName("vbxlmtgxrqihxbaf")
    public suspend fun sourceUri(`value`: Output<String>) {
        this.sourceUri = value
    }

    /**
     * @param value Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
     */
    @JvmName("yleqpnvnhhvxswvx")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
     */
    @JvmName("fgxkxpfbeigyodsw")
    public suspend fun uploadSizeBytes(`value`: Output<Double>) {
        this.uploadSizeBytes = value
    }

    /**
     * @param value This enumerates the possible sources of a disk's creation.
     */
    @JvmName("pycpwtfojpvmcksu")
    public suspend fun createOption(`value`: Either<String, DiskCreateOption>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value This enumerates the possible sources of a disk's creation.
     */
    @JvmName("yovsxayldikthnij")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskCreateOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value This enumerates the possible sources of a disk's creation.
     */
    @JvmName("dnnksfdahxujycqs")
    public fun createOption(`value`: DiskCreateOption) {
        val toBeMapped = Either.ofRight<String, DiskCreateOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
     */
    @JvmName("wesctrwuryjrdvpg")
    public suspend fun galleryImageReference(`value`: ImageDiskReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageReference = mapped
    }

    /**
     * @param argument Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
     */
    @JvmName("ldpkvwwhulripwsi")
    public suspend
    fun galleryImageReference(argument: suspend ImageDiskReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageDiskReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.galleryImageReference = mapped
    }

    /**
     * @param value Disk source information for PIR or user images.
     */
    @JvmName("nhwtdwpiskdkpgff")
    public suspend fun imageReference(`value`: ImageDiskReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument Disk source information for PIR or user images.
     */
    @JvmName("oqeomgbcnxjhhseh")
    public suspend fun imageReference(argument: suspend ImageDiskReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageDiskReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
     */
    @JvmName("mbthakaexnnbgear")
    public suspend fun logicalSectorSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalSectorSize = mapped
    }

    /**
     * @param value Set this flag to true to get a boost on the performance target of the disk deployed, see here on the respective performance target. This flag can only be set on disk creation time and cannot be disabled after enabled.
     */
    @JvmName("rnwrgqsddxvimpwu")
    public suspend fun performancePlus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performancePlus = mapped
    }

    /**
     * @param value If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
     */
    @JvmName("bylcqlwdduflkfjs")
    public suspend fun securityDataUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityDataUri = mapped
    }

    /**
     * @param value If createOption is Copy, this is the ARM id of the source snapshot or disk.
     */
    @JvmName("sxpbumbaijumgeuk")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value If createOption is Import, this is the URI of a blob to be imported into a managed disk.
     */
    @JvmName("jvfnddghljgtmlit")
    public suspend fun sourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUri = mapped
    }

    /**
     * @param value Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
     */
    @JvmName("ckfxbdrhsxuhrfrc")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
     */
    @JvmName("sjrdjksmcpicfghq")
    public suspend fun uploadSizeBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadSizeBytes = mapped
    }

    internal fun build(): CreationDataArgs = CreationDataArgs(
        createOption = createOption ?: throw PulumiNullFieldException("createOption"),
        galleryImageReference = galleryImageReference,
        imageReference = imageReference,
        logicalSectorSize = logicalSectorSize,
        performancePlus = performancePlus,
        securityDataUri = securityDataUri,
        sourceResourceId = sourceResourceId,
        sourceUri = sourceUri,
        storageAccountId = storageAccountId,
        uploadSizeBytes = uploadSizeBytes,
    )
}
