@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A custom action that can be performed with a Gallery Application Version.
 * @property description Description to help the users understand what this custom action does.
 * @property name The name of the custom action.  Must be unique within the Gallery Application Version.
 * @property parameters The parameters that this custom action uses
 * @property script The script to run when executing this custom action.
 */
public data class GalleryApplicationCustomActionArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val parameters: Output<List<GalleryApplicationCustomActionParameterArgs>>? = null,
    public val script: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionArgs =
        com.pulumi.azurenative.compute.inputs.GalleryApplicationCustomActionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .script(script.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryApplicationCustomActionArgs].
 */
@PulumiTagMarker
public class GalleryApplicationCustomActionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<GalleryApplicationCustomActionParameterArgs>>? = null

    private var script: Output<String>? = null

    /**
     * @param value Description to help the users understand what this custom action does.
     */
    @JvmName("yytikndyxndaausx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the custom action.  Must be unique within the Gallery Application Version.
     */
    @JvmName("fbwgjwfwxawbqjfe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters that this custom action uses
     */
    @JvmName("veichggirjvvlprw")
    public suspend
    fun parameters(`value`: Output<List<GalleryApplicationCustomActionParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("hpucavopcqtsjwev")
    public suspend fun parameters(
        vararg
        values: Output<GalleryApplicationCustomActionParameterArgs>,
    ) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters that this custom action uses
     */
    @JvmName("fnevjeryjqrefaav")
    public suspend fun parameters(values: List<Output<GalleryApplicationCustomActionParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The script to run when executing this custom action.
     */
    @JvmName("iynjvedeprmjxjlq")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Description to help the users understand what this custom action does.
     */
    @JvmName("hwmeabmelmqfiowi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the custom action.  Must be unique within the Gallery Application Version.
     */
    @JvmName("fscaewbyluplpkeo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters that this custom action uses
     */
    @JvmName("uftpxfhfygtnwokn")
    public suspend fun parameters(`value`: List<GalleryApplicationCustomActionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters that this custom action uses
     */
    @JvmName("cwyvadglciexlucb")
    public suspend
    fun parameters(argument: List<suspend GalleryApplicationCustomActionParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryApplicationCustomActionParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters that this custom action uses
     */
    @JvmName("jospfsxioiibxbhg")
    public suspend fun parameters(
        vararg
        argument: suspend GalleryApplicationCustomActionParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GalleryApplicationCustomActionParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters that this custom action uses
     */
    @JvmName("qldvfkdfcxgygsmr")
    public suspend
    fun parameters(argument: suspend GalleryApplicationCustomActionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GalleryApplicationCustomActionParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters that this custom action uses
     */
    @JvmName("vmuonheigujvkwqh")
    public suspend fun parameters(vararg values: GalleryApplicationCustomActionParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The script to run when executing this custom action.
     */
    @JvmName("kencmpkqyleutbmc")
    public suspend fun script(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.script = mapped
    }

    internal fun build(): GalleryApplicationCustomActionArgs = GalleryApplicationCustomActionArgs(
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters,
        script = script ?: throw PulumiNullFieldException("script"),
    )
}
