@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryImageFeatureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A feature for gallery image.
 * @property name The name of the gallery image feature.
 * @property value The value of the gallery image feature.
 */
public data class GalleryImageFeatureArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryImageFeatureArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryImageFeatureArgs =
        com.pulumi.azurenative.compute.inputs.GalleryImageFeatureArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryImageFeatureArgs].
 */
@PulumiTagMarker
public class GalleryImageFeatureArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the gallery image feature.
     */
    @JvmName("cbrjgmuonjudlbpj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the gallery image feature.
     */
    @JvmName("yptkgxynvtnsgtxf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the gallery image feature.
     */
    @JvmName("aimtsyadlwihjeie")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the gallery image feature.
     */
    @JvmName("wbxqpxgbagigtygh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GalleryImageFeatureArgs = GalleryImageFeatureArgs(
        name = name,
        `value` = `value`,
    )
}
