@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetCapacityReservationGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationGroupName The name of the capacity reservation group.
 * @property expand The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the capacity reservations under the capacity reservation group which is a snapshot of the runtime properties of a capacity reservation that is managed by the platform and can change outside of control plane operations.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetCapacityReservationGroupPlainArgs(
    public val capacityReservationGroupName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetCapacityReservationGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetCapacityReservationGroupPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetCapacityReservationGroupPlainArgs.builder()
            .capacityReservationGroupName(capacityReservationGroupName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCapacityReservationGroupPlainArgs].
 */
@PulumiTagMarker
public class GetCapacityReservationGroupPlainArgsBuilder internal constructor() {
    private var capacityReservationGroupName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the capacity reservation group.
     */
    @JvmName("fctjwfwyweklksfh")
    public suspend fun capacityReservationGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityReservationGroupName = mapped
    }

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the capacity reservations under the capacity reservation group which is a snapshot of the runtime properties of a capacity reservation that is managed by the platform and can change outside of control plane operations.
     */
    @JvmName("ypevkxwekfsiaudg")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xhqxewoxuwevvokk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCapacityReservationGroupPlainArgs = GetCapacityReservationGroupPlainArgs(
        capacityReservationGroupName = capacityReservationGroupName ?: throw
            PulumiNullFieldException("capacityReservationGroupName"),
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
