@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetRestorePointCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. If expand=restorePoints, server will return all contained restore points in the restorePointCollection.
 * @property resourceGroupName The name of the resource group.
 * @property restorePointCollectionName The name of the restore point collection.
 */
public data class GetRestorePointCollectionPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val restorePointCollectionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetRestorePointCollectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetRestorePointCollectionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetRestorePointCollectionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .restorePointCollectionName(restorePointCollectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRestorePointCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetRestorePointCollectionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var restorePointCollectionName: String? = null

    /**
     * @param value The expand expression to apply on the operation. If expand=restorePoints, server will return all contained restore points in the restorePointCollection.
     */
    @JvmName("mmfadwyunlyfpsdl")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mpvprgjlhfpjsgcu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the restore point collection.
     */
    @JvmName("bkyvtpskhfcwlofu")
    public suspend fun restorePointCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restorePointCollectionName = mapped
    }

    internal fun build(): GetRestorePointCollectionPlainArgs = GetRestorePointCollectionPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        restorePointCollectionName = restorePointCollectionName ?: throw
            PulumiNullFieldException("restorePointCollectionName"),
    )
}
