@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetSshPublicKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property sshPublicKeyName The name of the SSH public key.
 */
public data class GetSshPublicKeyPlainArgs(
    public val resourceGroupName: String,
    public val sshPublicKeyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetSshPublicKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetSshPublicKeyPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetSshPublicKeyPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sshPublicKeyName(sshPublicKeyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSshPublicKeyPlainArgs].
 */
@PulumiTagMarker
public class GetSshPublicKeyPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sshPublicKeyName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ldhyqrvmkwmxexqt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SSH public key.
     */
    @JvmName("umuwkoqhorxpdghf")
    public suspend fun sshPublicKeyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sshPublicKeyName = mapped
    }

    internal fun build(): GetSshPublicKeyPlainArgs = GetSshPublicKeyPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sshPublicKeyName = sshPublicKeyName ?: throw PulumiNullFieldException("sshPublicKeyName"),
    )
}
