@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.InstanceViewStatusArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.StatusLevelTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Instance view status.
 * @property code The status code.
 * @property displayStatus The short localizable label for the status.
 * @property level The level code.
 * @property message The detailed status message, including for alerts and error messages.
 * @property time The time of the status.
 */
public data class InstanceViewStatusArgs(
    public val code: Output<String>? = null,
    public val displayStatus: Output<String>? = null,
    public val level: Output<StatusLevelTypes>? = null,
    public val message: Output<String>? = null,
    public val time: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.InstanceViewStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.InstanceViewStatusArgs =
        com.pulumi.azurenative.compute.inputs.InstanceViewStatusArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .displayStatus(displayStatus?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .message(message?.applyValue({ args0 -> args0 }))
            .time(time?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceViewStatusArgs].
 */
@PulumiTagMarker
public class InstanceViewStatusArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var displayStatus: Output<String>? = null

    private var level: Output<StatusLevelTypes>? = null

    private var message: Output<String>? = null

    private var time: Output<String>? = null

    /**
     * @param value The status code.
     */
    @JvmName("svuemrwjhtdyvoac")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The short localizable label for the status.
     */
    @JvmName("gjiytilxjbnwtyio")
    public suspend fun displayStatus(`value`: Output<String>) {
        this.displayStatus = value
    }

    /**
     * @param value The level code.
     */
    @JvmName("aluullpgdbpvkobl")
    public suspend fun level(`value`: Output<StatusLevelTypes>) {
        this.level = value
    }

    /**
     * @param value The detailed status message, including for alerts and error messages.
     */
    @JvmName("nobpyccjfscikgpb")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The time of the status.
     */
    @JvmName("lwruutfquapixrmv")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The status code.
     */
    @JvmName("ngqnaebksuxlklxj")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The short localizable label for the status.
     */
    @JvmName("ujusdsdpfwulpmub")
    public suspend fun displayStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayStatus = mapped
    }

    /**
     * @param value The level code.
     */
    @JvmName("qcxmybmsboottyml")
    public suspend fun level(`value`: StatusLevelTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The detailed status message, including for alerts and error messages.
     */
    @JvmName("avdjiitshhvlhnos")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The time of the status.
     */
    @JvmName("lwotdkeegjwdmnqf")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): InstanceViewStatusArgs = InstanceViewStatusArgs(
        code = code,
        displayStatus = displayStatus,
        level = level,
        message = message,
        time = time,
    )
}
