@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.KeyForDiskEncryptionSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
 * @property keyUrl Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
 * @property sourceVault Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
 */
public data class KeyForDiskEncryptionSetArgs(
    public val keyUrl: Output<String>,
    public val sourceVault: Output<SourceVaultArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.KeyForDiskEncryptionSetArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.KeyForDiskEncryptionSetArgs =
        com.pulumi.azurenative.compute.inputs.KeyForDiskEncryptionSetArgs.builder()
            .keyUrl(keyUrl.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyForDiskEncryptionSetArgs].
 */
@PulumiTagMarker
public class KeyForDiskEncryptionSetArgsBuilder internal constructor() {
    private var keyUrl: Output<String>? = null

    private var sourceVault: Output<SourceVaultArgs>? = null

    /**
     * @param value Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
     */
    @JvmName("ahtcbvfpyrjhrirk")
    public suspend fun keyUrl(`value`: Output<String>) {
        this.keyUrl = value
    }

    /**
     * @param value Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     */
    @JvmName("ligwaocgshldauwt")
    public suspend fun sourceVault(`value`: Output<SourceVaultArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
     */
    @JvmName("ahdckhgjqvldlytm")
    public suspend fun keyUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyUrl = mapped
    }

    /**
     * @param value Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     */
    @JvmName("wsmgtmroffiggnsy")
    public suspend fun sourceVault(`value`: SourceVaultArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     */
    @JvmName("sjsutdcckdlrglwd")
    public suspend fun sourceVault(argument: suspend SourceVaultArgsBuilder.() -> Unit) {
        val toBeMapped = SourceVaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): KeyForDiskEncryptionSetArgs = KeyForDiskEncryptionSetArgs(
        keyUrl = keyUrl ?: throw PulumiNullFieldException("keyUrl"),
        sourceVault = sourceVault,
    )
}
