@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.KeyVaultAndKeyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
 * @property keyUrl Url pointing to a key or secret in KeyVault
 * @property sourceVault Resource id of the KeyVault containing the key or secret
 */
public data class KeyVaultAndKeyReferenceArgs(
    public val keyUrl: Output<String>,
    public val sourceVault: Output<SourceVaultArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.KeyVaultAndKeyReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.KeyVaultAndKeyReferenceArgs =
        com.pulumi.azurenative.compute.inputs.KeyVaultAndKeyReferenceArgs.builder()
            .keyUrl(keyUrl.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultAndKeyReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultAndKeyReferenceArgsBuilder internal constructor() {
    private var keyUrl: Output<String>? = null

    private var sourceVault: Output<SourceVaultArgs>? = null

    /**
     * @param value Url pointing to a key or secret in KeyVault
     */
    @JvmName("xfjnpjswkraamswh")
    public suspend fun keyUrl(`value`: Output<String>) {
        this.keyUrl = value
    }

    /**
     * @param value Resource id of the KeyVault containing the key or secret
     */
    @JvmName("ttdgbpxgiyxnclhf")
    public suspend fun sourceVault(`value`: Output<SourceVaultArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value Url pointing to a key or secret in KeyVault
     */
    @JvmName("egtlsqdipigyklwd")
    public suspend fun keyUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyUrl = mapped
    }

    /**
     * @param value Resource id of the KeyVault containing the key or secret
     */
    @JvmName("ffyadyouehjlfkse")
    public suspend fun sourceVault(`value`: SourceVaultArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument Resource id of the KeyVault containing the key or secret
     */
    @JvmName("ncjlcvudfwtjnrba")
    public suspend fun sourceVault(argument: suspend SourceVaultArgsBuilder.() -> Unit) {
        val toBeMapped = SourceVaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): KeyVaultAndKeyReferenceArgs = KeyVaultAndKeyReferenceArgs(
        keyUrl = keyUrl ?: throw PulumiNullFieldException("keyUrl"),
        sourceVault = sourceVault ?: throw PulumiNullFieldException("sourceVault"),
    )
}
