@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a cloud service IP Configuration
 * @property privateIPAddress The virtual network private IP address of the IP configuration.
 * @property publicIPAddress The reference to the public ip address resource.
 * @property subnet The reference to the virtual network subnet resource.
 */
public data class LoadBalancerFrontendIpConfigurationPropertiesArgs(
    public val privateIPAddress: Output<String>? = null,
    public val publicIPAddress: Output<SubResourceArgs>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs =
        com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs.builder()
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LoadBalancerFrontendIpConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class LoadBalancerFrontendIpConfigurationPropertiesArgsBuilder internal constructor() {
    private var privateIPAddress: Output<String>? = null

    private var publicIPAddress: Output<SubResourceArgs>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value The virtual network private IP address of the IP configuration.
     */
    @JvmName("tolecajnqnpyxrwd")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The reference to the public ip address resource.
     */
    @JvmName("sfokkrtlrrbirkip")
    public suspend fun publicIPAddress(`value`: Output<SubResourceArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value The reference to the virtual network subnet resource.
     */
    @JvmName("jvkqxhxpddnlxvog")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value The virtual network private IP address of the IP configuration.
     */
    @JvmName("qqsfuekhmofurmfd")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The reference to the public ip address resource.
     */
    @JvmName("triqqjdwsrwdmaem")
    public suspend fun publicIPAddress(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument The reference to the public ip address resource.
     */
    @JvmName("fpbudeaeujgvliof")
    public suspend fun publicIPAddress(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value The reference to the virtual network subnet resource.
     */
    @JvmName("cbgobaflognurfwp")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the virtual network subnet resource.
     */
    @JvmName("hcrbubvjasnrmnqh")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): LoadBalancerFrontendIpConfigurationPropertiesArgs =
        LoadBalancerFrontendIpConfigurationPropertiesArgs(
            privateIPAddress = privateIPAddress,
            publicIPAddress = publicIPAddress,
            subnet = subnet,
        )
}
