@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.OSDiskImageEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contains encryption settings for an OS disk image.
 * @property diskEncryptionSetId A relative URI containing the resource ID of the disk encryption set.
 * @property securityProfile This property specifies the security profile of an OS disk image.
 */
public data class OSDiskImageEncryptionArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val securityProfile: Output<OSDiskImageSecurityProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.OSDiskImageEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.OSDiskImageEncryptionArgs =
        com.pulumi.azurenative.compute.inputs.OSDiskImageEncryptionArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .securityProfile(
                securityProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OSDiskImageEncryptionArgs].
 */
@PulumiTagMarker
public class OSDiskImageEncryptionArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var securityProfile: Output<OSDiskImageSecurityProfileArgs>? = null

    /**
     * @param value A relative URI containing the resource ID of the disk encryption set.
     */
    @JvmName("kokkkmgbakuibesj")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value This property specifies the security profile of an OS disk image.
     */
    @JvmName("duhgahfshrxlegyw")
    public suspend fun securityProfile(`value`: Output<OSDiskImageSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value A relative URI containing the resource ID of the disk encryption set.
     */
    @JvmName("subcwixwstldegsb")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value This property specifies the security profile of an OS disk image.
     */
    @JvmName("kqhwhhhnysmckxvh")
    public suspend fun securityProfile(`value`: OSDiskImageSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument This property specifies the security profile of an OS disk image.
     */
    @JvmName("ixybcqqigaujidxo")
    public suspend
    fun securityProfile(argument: suspend OSDiskImageSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OSDiskImageSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    internal fun build(): OSDiskImageEncryptionArgs = OSDiskImageEncryptionArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        securityProfile = securityProfile,
    )
}
