@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable Specifies whether the OS Image Scheduled event is enabled or disabled.
 * @property notBeforeTimeout Length of time a Virtual Machine being reimaged or having its OS upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto approved (timed out). The configuration is specified in ISO 8601 format, and the value must be 15 minutes (PT15M)
 */
public data class OSImageNotificationProfileArgs(
    public val enable: Output<Boolean>? = null,
    public val notBeforeTimeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs =
        com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .notBeforeTimeout(notBeforeTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OSImageNotificationProfileArgs].
 */
@PulumiTagMarker
public class OSImageNotificationProfileArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var notBeforeTimeout: Output<String>? = null

    /**
     * @param value Specifies whether the OS Image Scheduled event is enabled or disabled.
     */
    @JvmName("nnltvqleqsluwqtg")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Length of time a Virtual Machine being reimaged or having its OS upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto approved (timed out). The configuration is specified in ISO 8601 format, and the value must be 15 minutes (PT15M)
     */
    @JvmName("byqsyeprrgvvhyud")
    public suspend fun notBeforeTimeout(`value`: Output<String>) {
        this.notBeforeTimeout = value
    }

    /**
     * @param value Specifies whether the OS Image Scheduled event is enabled or disabled.
     */
    @JvmName("stiudhxbraoxhxsw")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Length of time a Virtual Machine being reimaged or having its OS upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto approved (timed out). The configuration is specified in ISO 8601 format, and the value must be 15 minutes (PT15M)
     */
    @JvmName("gyqqqnahsnfwtsrd")
    public suspend fun notBeforeTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notBeforeTimeout = mapped
    }

    internal fun build(): OSImageNotificationProfileArgs = OSImageNotificationProfileArgs(
        enable = enable,
        notBeforeTimeout = notBeforeTimeout,
    )
}
