@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ProximityPlacementGroupPropertiesIntentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the user intent of the proximity placement group.
 * @property vmSizes Specifies possible sizes of virtual machines that can be created in the proximity placement group.
 */
public data class ProximityPlacementGroupPropertiesIntentArgs(
    public val vmSizes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ProximityPlacementGroupPropertiesIntentArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.ProximityPlacementGroupPropertiesIntentArgs =
        com.pulumi.azurenative.compute.inputs.ProximityPlacementGroupPropertiesIntentArgs.builder()
            .vmSizes(vmSizes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProximityPlacementGroupPropertiesIntentArgs].
 */
@PulumiTagMarker
public class ProximityPlacementGroupPropertiesIntentArgsBuilder internal constructor() {
    private var vmSizes: Output<List<String>>? = null

    /**
     * @param value Specifies possible sizes of virtual machines that can be created in the proximity placement group.
     */
    @JvmName("rvwpmietcykbnmye")
    public suspend fun vmSizes(`value`: Output<List<String>>) {
        this.vmSizes = value
    }

    @JvmName("ogqyxngihtyswcad")
    public suspend fun vmSizes(vararg values: Output<String>) {
        this.vmSizes = Output.all(values.asList())
    }

    /**
     * @param values Specifies possible sizes of virtual machines that can be created in the proximity placement group.
     */
    @JvmName("twhyntrdsuctjbcd")
    public suspend fun vmSizes(values: List<Output<String>>) {
        this.vmSizes = Output.all(values)
    }

    /**
     * @param value Specifies possible sizes of virtual machines that can be created in the proximity placement group.
     */
    @JvmName("iknarusipjkxhetr")
    public suspend fun vmSizes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSizes = mapped
    }

    /**
     * @param values Specifies possible sizes of virtual machines that can be created in the proximity placement group.
     */
    @JvmName("dhvhphdlsvydsorg")
    public suspend fun vmSizes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSizes = mapped
    }

    internal fun build(): ProximityPlacementGroupPropertiesIntentArgs =
        ProximityPlacementGroupPropertiesIntentArgs(
            vmSizes = vmSizes,
        )
}
