@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RecommendedMachineConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
 * @property memory Describes the resource range.
 * @property vCPUs Describes the resource range.
 */
public data class RecommendedMachineConfigurationArgs(
    public val memory: Output<ResourceRangeArgs>? = null,
    public val vCPUs: Output<ResourceRangeArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RecommendedMachineConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RecommendedMachineConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.RecommendedMachineConfigurationArgs.builder()
            .memory(memory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vCPUs(vCPUs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RecommendedMachineConfigurationArgs].
 */
@PulumiTagMarker
public class RecommendedMachineConfigurationArgsBuilder internal constructor() {
    private var memory: Output<ResourceRangeArgs>? = null

    private var vCPUs: Output<ResourceRangeArgs>? = null

    /**
     * @param value Describes the resource range.
     */
    @JvmName("fairgmvcadedkics")
    public suspend fun memory(`value`: Output<ResourceRangeArgs>) {
        this.memory = value
    }

    /**
     * @param value Describes the resource range.
     */
    @JvmName("ynltpsjhxfvjpodu")
    public suspend fun vCPUs(`value`: Output<ResourceRangeArgs>) {
        this.vCPUs = value
    }

    /**
     * @param value Describes the resource range.
     */
    @JvmName("vqgqlsdgvmxegmmu")
    public suspend fun memory(`value`: ResourceRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param argument Describes the resource range.
     */
    @JvmName("vjrxhlcfxebehpbu")
    public suspend fun memory(argument: suspend ResourceRangeArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.memory = mapped
    }

    /**
     * @param value Describes the resource range.
     */
    @JvmName("xvkpndlyepsfaler")
    public suspend fun vCPUs(`value`: ResourceRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCPUs = mapped
    }

    /**
     * @param argument Describes the resource range.
     */
    @JvmName("wwbinjkpcrjpspsf")
    public suspend fun vCPUs(argument: suspend ResourceRangeArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vCPUs = mapped
    }

    internal fun build(): RecommendedMachineConfigurationArgs = RecommendedMachineConfigurationArgs(
        memory = memory,
        vCPUs = vCPUs,
    )
}
