@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RestorePointCollectionSourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the source resource that this restore point collection is created from.
 * @property id Resource Id of the source resource used to create this restore point collection
 */
public data class RestorePointCollectionSourcePropertiesArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RestorePointCollectionSourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.RestorePointCollectionSourcePropertiesArgs =
        com.pulumi.azurenative.compute.inputs.RestorePointCollectionSourcePropertiesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestorePointCollectionSourcePropertiesArgs].
 */
@PulumiTagMarker
public class RestorePointCollectionSourcePropertiesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource Id of the source resource used to create this restore point collection
     */
    @JvmName("pxrolhwlocnyvxfh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource Id of the source resource used to create this restore point collection
     */
    @JvmName("ditrdqwwhdffyywg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): RestorePointCollectionSourcePropertiesArgs =
        RestorePointCollectionSourcePropertiesArgs(
            id = id,
        )
}
