@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RestorePointSourceMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the properties of the Virtual Machine for which the restore point was created. The properties provided are a subset and the snapshot of the overall Virtual Machine properties captured at the time of the restore point creation.
 * @property storageProfile Gets the storage profile.
 */
public data class RestorePointSourceMetadataArgs(
    public val storageProfile: Output<RestorePointSourceVMStorageProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RestorePointSourceMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RestorePointSourceMetadataArgs =
        com.pulumi.azurenative.compute.inputs.RestorePointSourceMetadataArgs.builder()
            .storageProfile(
                storageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RestorePointSourceMetadataArgs].
 */
@PulumiTagMarker
public class RestorePointSourceMetadataArgsBuilder internal constructor() {
    private var storageProfile: Output<RestorePointSourceVMStorageProfileArgs>? = null

    /**
     * @param value Gets the storage profile.
     */
    @JvmName("dsdbxhwpovimvrpr")
    public suspend fun storageProfile(`value`: Output<RestorePointSourceVMStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Gets the storage profile.
     */
    @JvmName("gmgjadbbnjowomyi")
    public suspend fun storageProfile(`value`: RestorePointSourceVMStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Gets the storage profile.
     */
    @JvmName("qicilnhmykvyxugb")
    public suspend
    fun storageProfile(argument: suspend RestorePointSourceVMStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = RestorePointSourceVMStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    internal fun build(): RestorePointSourceMetadataArgs = RestorePointSourceMetadataArgs(
        storageProfile = storageProfile,
    )
}
