@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RestorePointSourceVMDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a data disk.
 * @property diskRestorePoint Contains Disk Restore Point properties.
 * @property managedDisk Contains the managed disk details.
 */
public data class RestorePointSourceVMDataDiskArgs(
    public val diskRestorePoint: Output<DiskRestorePointAttributesArgs>? = null,
    public val managedDisk: Output<ManagedDiskParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RestorePointSourceVMDataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RestorePointSourceVMDataDiskArgs =
        com.pulumi.azurenative.compute.inputs.RestorePointSourceVMDataDiskArgs.builder()
            .diskRestorePoint(diskRestorePoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RestorePointSourceVMDataDiskArgs].
 */
@PulumiTagMarker
public class RestorePointSourceVMDataDiskArgsBuilder internal constructor() {
    private var diskRestorePoint: Output<DiskRestorePointAttributesArgs>? = null

    private var managedDisk: Output<ManagedDiskParametersArgs>? = null

    /**
     * @param value Contains Disk Restore Point properties.
     */
    @JvmName("wseuypqsihjftlof")
    public suspend fun diskRestorePoint(`value`: Output<DiskRestorePointAttributesArgs>) {
        this.diskRestorePoint = value
    }

    /**
     * @param value Contains the managed disk details.
     */
    @JvmName("thpfglchnaqaadkj")
    public suspend fun managedDisk(`value`: Output<ManagedDiskParametersArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value Contains Disk Restore Point properties.
     */
    @JvmName("nwuvviihtckveoeq")
    public suspend fun diskRestorePoint(`value`: DiskRestorePointAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskRestorePoint = mapped
    }

    /**
     * @param argument Contains Disk Restore Point properties.
     */
    @JvmName("isyjohlrilffrdqq")
    public suspend
    fun diskRestorePoint(argument: suspend DiskRestorePointAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = DiskRestorePointAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskRestorePoint = mapped
    }

    /**
     * @param value Contains the managed disk details.
     */
    @JvmName("dswseqndyarkadvi")
    public suspend fun managedDisk(`value`: ManagedDiskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument Contains the managed disk details.
     */
    @JvmName("pvnqbtuhwmtvstgc")
    public suspend fun managedDisk(argument: suspend ManagedDiskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedDiskParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    internal fun build(): RestorePointSourceVMDataDiskArgs = RestorePointSourceVMDataDiskArgs(
        diskRestorePoint = diskRestorePoint,
        managedDisk = managedDisk,
    )
}
