@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RollingUpgradePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration parameters used while performing a rolling upgrade.
 * @property enableCrossZoneUpgrade Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
 * @property maxBatchInstancePercent The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
 * @property maxSurge Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch.
 * @property maxUnhealthyInstancePercent The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
 * @property maxUnhealthyUpgradedInstancePercent The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
 * @property pauseTimeBetweenBatches The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
 * @property prioritizeUnhealthyInstances Upgrade all unhealthy instances in a scale set before any healthy instances.
 * @property rollbackFailedInstancesOnPolicyBreach Rollback failed instances to previous model if the Rolling Upgrade policy is violated.
 */
public data class RollingUpgradePolicyArgs(
    public val enableCrossZoneUpgrade: Output<Boolean>? = null,
    public val maxBatchInstancePercent: Output<Int>? = null,
    public val maxSurge: Output<Boolean>? = null,
    public val maxUnhealthyInstancePercent: Output<Int>? = null,
    public val maxUnhealthyUpgradedInstancePercent: Output<Int>? = null,
    public val pauseTimeBetweenBatches: Output<String>? = null,
    public val prioritizeUnhealthyInstances: Output<Boolean>? = null,
    public val rollbackFailedInstancesOnPolicyBreach: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RollingUpgradePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RollingUpgradePolicyArgs =
        com.pulumi.azurenative.compute.inputs.RollingUpgradePolicyArgs.builder()
            .enableCrossZoneUpgrade(enableCrossZoneUpgrade?.applyValue({ args0 -> args0 }))
            .maxBatchInstancePercent(maxBatchInstancePercent?.applyValue({ args0 -> args0 }))
            .maxSurge(maxSurge?.applyValue({ args0 -> args0 }))
            .maxUnhealthyInstancePercent(maxUnhealthyInstancePercent?.applyValue({ args0 -> args0 }))
            .maxUnhealthyUpgradedInstancePercent(
                maxUnhealthyUpgradedInstancePercent?.applyValue({ args0 ->
                    args0
                }),
            )
            .pauseTimeBetweenBatches(pauseTimeBetweenBatches?.applyValue({ args0 -> args0 }))
            .prioritizeUnhealthyInstances(prioritizeUnhealthyInstances?.applyValue({ args0 -> args0 }))
            .rollbackFailedInstancesOnPolicyBreach(
                rollbackFailedInstancesOnPolicyBreach?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [RollingUpgradePolicyArgs].
 */
@PulumiTagMarker
public class RollingUpgradePolicyArgsBuilder internal constructor() {
    private var enableCrossZoneUpgrade: Output<Boolean>? = null

    private var maxBatchInstancePercent: Output<Int>? = null

    private var maxSurge: Output<Boolean>? = null

    private var maxUnhealthyInstancePercent: Output<Int>? = null

    private var maxUnhealthyUpgradedInstancePercent: Output<Int>? = null

    private var pauseTimeBetweenBatches: Output<String>? = null

    private var prioritizeUnhealthyInstances: Output<Boolean>? = null

    private var rollbackFailedInstancesOnPolicyBreach: Output<Boolean>? = null

    /**
     * @param value Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
     */
    @JvmName("lqxcdjrpuregbgxv")
    public suspend fun enableCrossZoneUpgrade(`value`: Output<Boolean>) {
        this.enableCrossZoneUpgrade = value
    }

    /**
     * @param value The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
     */
    @JvmName("wbqucivftrimsbcs")
    public suspend fun maxBatchInstancePercent(`value`: Output<Int>) {
        this.maxBatchInstancePercent = value
    }

    /**
     * @param value Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch.
     */
    @JvmName("tkwthvnjotqdlcqm")
    public suspend fun maxSurge(`value`: Output<Boolean>) {
        this.maxSurge = value
    }

    /**
     * @param value The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
     */
    @JvmName("mvjvykjkcndkgmhh")
    public suspend fun maxUnhealthyInstancePercent(`value`: Output<Int>) {
        this.maxUnhealthyInstancePercent = value
    }

    /**
     * @param value The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
     */
    @JvmName("lqjetsetavvhymqo")
    public suspend fun maxUnhealthyUpgradedInstancePercent(`value`: Output<Int>) {
        this.maxUnhealthyUpgradedInstancePercent = value
    }

    /**
     * @param value The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
     */
    @JvmName("rphyifxwtmfnglrf")
    public suspend fun pauseTimeBetweenBatches(`value`: Output<String>) {
        this.pauseTimeBetweenBatches = value
    }

    /**
     * @param value Upgrade all unhealthy instances in a scale set before any healthy instances.
     */
    @JvmName("fogodowwoenpnvff")
    public suspend fun prioritizeUnhealthyInstances(`value`: Output<Boolean>) {
        this.prioritizeUnhealthyInstances = value
    }

    /**
     * @param value Rollback failed instances to previous model if the Rolling Upgrade policy is violated.
     */
    @JvmName("yiohkmuhvfueelrq")
    public suspend fun rollbackFailedInstancesOnPolicyBreach(`value`: Output<Boolean>) {
        this.rollbackFailedInstancesOnPolicyBreach = value
    }

    /**
     * @param value Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
     */
    @JvmName("xbaotngfiqlvedly")
    public suspend fun enableCrossZoneUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCrossZoneUpgrade = mapped
    }

    /**
     * @param value The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
     */
    @JvmName("mvwgptjaxeihgjsw")
    public suspend fun maxBatchInstancePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchInstancePercent = mapped
    }

    /**
     * @param value Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch.
     */
    @JvmName("adwhwbkhsjperoxy")
    public suspend fun maxSurge(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSurge = mapped
    }

    /**
     * @param value The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
     */
    @JvmName("wieuefjvadrxjiwc")
    public suspend fun maxUnhealthyInstancePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnhealthyInstancePercent = mapped
    }

    /**
     * @param value The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
     */
    @JvmName("renyfifwuultuwte")
    public suspend fun maxUnhealthyUpgradedInstancePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnhealthyUpgradedInstancePercent = mapped
    }

    /**
     * @param value The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
     */
    @JvmName("ayrpajaacbavmife")
    public suspend fun pauseTimeBetweenBatches(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pauseTimeBetweenBatches = mapped
    }

    /**
     * @param value Upgrade all unhealthy instances in a scale set before any healthy instances.
     */
    @JvmName("unphsuucbcrnywnp")
    public suspend fun prioritizeUnhealthyInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prioritizeUnhealthyInstances = mapped
    }

    /**
     * @param value Rollback failed instances to previous model if the Rolling Upgrade policy is violated.
     */
    @JvmName("gjkwjyuocobakxnv")
    public suspend fun rollbackFailedInstancesOnPolicyBreach(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollbackFailedInstancesOnPolicyBreach = mapped
    }

    internal fun build(): RollingUpgradePolicyArgs = RollingUpgradePolicyArgs(
        enableCrossZoneUpgrade = enableCrossZoneUpgrade,
        maxBatchInstancePercent = maxBatchInstancePercent,
        maxSurge = maxSurge,
        maxUnhealthyInstancePercent = maxUnhealthyInstancePercent,
        maxUnhealthyUpgradedInstancePercent = maxUnhealthyUpgradedInstancePercent,
        pauseTimeBetweenBatches = pauseTimeBetweenBatches,
        prioritizeUnhealthyInstances = prioritizeUnhealthyInstances,
        rollbackFailedInstancesOnPolicyBreach = rollbackFailedInstancesOnPolicyBreach,
    )
}
