@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable Specifies whether the Terminate Scheduled event is enabled or disabled.
 * @property notBeforeTimeout Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
 */
public data class TerminateNotificationProfileArgs(
    public val enable: Output<Boolean>? = null,
    public val notBeforeTimeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs =
        com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .notBeforeTimeout(notBeforeTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TerminateNotificationProfileArgs].
 */
@PulumiTagMarker
public class TerminateNotificationProfileArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var notBeforeTimeout: Output<String>? = null

    /**
     * @param value Specifies whether the Terminate Scheduled event is enabled or disabled.
     */
    @JvmName("uxkqibybkxkcttmn")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
     */
    @JvmName("keykixtsfhjqauox")
    public suspend fun notBeforeTimeout(`value`: Output<String>) {
        this.notBeforeTimeout = value
    }

    /**
     * @param value Specifies whether the Terminate Scheduled event is enabled or disabled.
     */
    @JvmName("jqmumyxqimsxcwqh")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)
     */
    @JvmName("succrlwlwbwqfdqo")
    public suspend fun notBeforeTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notBeforeTimeout = mapped
    }

    internal fun build(): TerminateNotificationProfileArgs = TerminateNotificationProfileArgs(
        enable = enable,
        notBeforeTimeout = notBeforeTimeout,
    )
}
