@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.UpgradeMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an upgrade policy - automatic, manual, or rolling.
 * @property automaticOSUpgradePolicy Configuration parameters used for performing automatic OS Upgrade.
 * @property mode Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
 * @property rollingUpgradePolicy The configuration parameters used while performing a rolling upgrade.
 */
public data class UpgradePolicyArgs(
    public val automaticOSUpgradePolicy: Output<AutomaticOSUpgradePolicyArgs>? = null,
    public val mode: Output<UpgradeMode>? = null,
    public val rollingUpgradePolicy: Output<RollingUpgradePolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs =
        com.pulumi.azurenative.compute.inputs.UpgradePolicyArgs.builder()
            .automaticOSUpgradePolicy(
                automaticOSUpgradePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mode(mode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rollingUpgradePolicy(
                rollingUpgradePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UpgradePolicyArgs].
 */
@PulumiTagMarker
public class UpgradePolicyArgsBuilder internal constructor() {
    private var automaticOSUpgradePolicy: Output<AutomaticOSUpgradePolicyArgs>? = null

    private var mode: Output<UpgradeMode>? = null

    private var rollingUpgradePolicy: Output<RollingUpgradePolicyArgs>? = null

    /**
     * @param value Configuration parameters used for performing automatic OS Upgrade.
     */
    @JvmName("btmmocjrtplmqkbs")
    public suspend fun automaticOSUpgradePolicy(`value`: Output<AutomaticOSUpgradePolicyArgs>) {
        this.automaticOSUpgradePolicy = value
    }

    /**
     * @param value Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
     */
    @JvmName("jumrkyiwkjcrqtnr")
    public suspend fun mode(`value`: Output<UpgradeMode>) {
        this.mode = value
    }

    /**
     * @param value The configuration parameters used while performing a rolling upgrade.
     */
    @JvmName("wxxomafariaualdn")
    public suspend fun rollingUpgradePolicy(`value`: Output<RollingUpgradePolicyArgs>) {
        this.rollingUpgradePolicy = value
    }

    /**
     * @param value Configuration parameters used for performing automatic OS Upgrade.
     */
    @JvmName("kptahcycqoqbuapo")
    public suspend fun automaticOSUpgradePolicy(`value`: AutomaticOSUpgradePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticOSUpgradePolicy = mapped
    }

    /**
     * @param argument Configuration parameters used for performing automatic OS Upgrade.
     */
    @JvmName("wgckvdogheyicqli")
    public suspend
    fun automaticOSUpgradePolicy(argument: suspend AutomaticOSUpgradePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = AutomaticOSUpgradePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.automaticOSUpgradePolicy = mapped
    }

    /**
     * @param value Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
     */
    @JvmName("akkvdbusboyjeqee")
    public suspend fun mode(`value`: UpgradeMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The configuration parameters used while performing a rolling upgrade.
     */
    @JvmName("apcqyspqijmxsbsy")
    public suspend fun rollingUpgradePolicy(`value`: RollingUpgradePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollingUpgradePolicy = mapped
    }

    /**
     * @param argument The configuration parameters used while performing a rolling upgrade.
     */
    @JvmName("oqoseknlnuyoxbpq")
    public suspend
    fun rollingUpgradePolicy(argument: suspend RollingUpgradePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RollingUpgradePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rollingUpgradePolicy = mapped
    }

    internal fun build(): UpgradePolicyArgs = UpgradePolicyArgs(
        automaticOSUpgradePolicy = automaticOSUpgradePolicy,
        mode = mode,
        rollingUpgradePolicy = rollingUpgradePolicy,
    )
}
