@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 * @property domainNameLabel The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 */
public data class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs(
    public val domainNameLabel: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs.builder()
            .domainNameLabel(domainNameLabel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgsBuilder internal
constructor() {
    private var domainNameLabel: Output<String>? = null

    /**
     * @param value The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("sfajsfhffgocgehr")
    public suspend fun domainNameLabel(`value`: Output<String>) {
        this.domainNameLabel = value
    }

    /**
     * @param value The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("xdfcnktohbqllqbl")
    public suspend fun domainNameLabel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNameLabel = mapped
    }

    internal fun build(): VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs =
        VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs(
            domainNameLabel = domainNameLabel ?: throw PulumiNullFieldException("domainNameLabel"),
        )
}
