@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProtectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The protection policy of a virtual machine scale set VM.
 * @property protectFromScaleIn Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
 * @property protectFromScaleSetActions Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
 */
public data class VirtualMachineScaleSetVMProtectionPolicyArgs(
    public val protectFromScaleIn: Output<Boolean>? = null,
    public val protectFromScaleSetActions: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProtectionPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProtectionPolicyArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProtectionPolicyArgs.builder()
            .protectFromScaleIn(protectFromScaleIn?.applyValue({ args0 -> args0 }))
            .protectFromScaleSetActions(protectFromScaleSetActions?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetVMProtectionPolicyArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMProtectionPolicyArgsBuilder internal constructor() {
    private var protectFromScaleIn: Output<Boolean>? = null

    private var protectFromScaleSetActions: Output<Boolean>? = null

    /**
     * @param value Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
     */
    @JvmName("dnoanwrgehccudph")
    public suspend fun protectFromScaleIn(`value`: Output<Boolean>) {
        this.protectFromScaleIn = value
    }

    /**
     * @param value Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
     */
    @JvmName("gvdvpexkpxegxpwj")
    public suspend fun protectFromScaleSetActions(`value`: Output<Boolean>) {
        this.protectFromScaleSetActions = value
    }

    /**
     * @param value Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
     */
    @JvmName("xuegctlseemwphon")
    public suspend fun protectFromScaleIn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectFromScaleIn = mapped
    }

    /**
     * @param value Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.
     */
    @JvmName("tsywrcdewynnbchs")
    public suspend fun protectFromScaleSetActions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectFromScaleSetActions = mapped
    }

    internal fun build(): VirtualMachineScaleSetVMProtectionPolicyArgs =
        VirtualMachineScaleSetVMProtectionPolicyArgs(
            protectFromScaleIn = protectFromScaleIn,
            protectFromScaleSetActions = protectFromScaleSetActions,
        )
}
