@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies Windows operating system settings on the virtual machine.
 * @property additionalUnattendContent Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
 * @property enableAutomaticUpdates Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
 * @property enableVMAgentPlatformUpdates Indicates whether VMAgent Platform Updates is enabled for the Windows virtual machine. Default value is false.
 * @property patchSettings [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
 * @property provisionVMAgent Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, it is set to true by default. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
 * @property timeZone Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". Possible values can be [TimeZoneInfo&#46;Id](https://docs&#46;microsoft&#46;com/dotnet/api/system&#46;timezoneinfo&#46;id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo&#46;GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
 * @property winRM Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
 */
public data class WindowsConfigurationArgs(
    public val additionalUnattendContent: Output<List<AdditionalUnattendContentArgs>>? = null,
    public val enableAutomaticUpdates: Output<Boolean>? = null,
    public val enableVMAgentPlatformUpdates: Output<Boolean>? = null,
    public val patchSettings: Output<PatchSettingsArgs>? = null,
    public val provisionVMAgent: Output<Boolean>? = null,
    public val timeZone: Output<String>? = null,
    public val winRM: Output<WinRMConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs.builder()
            .additionalUnattendContent(
                additionalUnattendContent?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableAutomaticUpdates(enableAutomaticUpdates?.applyValue({ args0 -> args0 }))
            .enableVMAgentPlatformUpdates(enableVMAgentPlatformUpdates?.applyValue({ args0 -> args0 }))
            .patchSettings(patchSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisionVMAgent(provisionVMAgent?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .winRM(winRM?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WindowsConfigurationArgs].
 */
@PulumiTagMarker
public class WindowsConfigurationArgsBuilder internal constructor() {
    private var additionalUnattendContent: Output<List<AdditionalUnattendContentArgs>>? = null

    private var enableAutomaticUpdates: Output<Boolean>? = null

    private var enableVMAgentPlatformUpdates: Output<Boolean>? = null

    private var patchSettings: Output<PatchSettingsArgs>? = null

    private var provisionVMAgent: Output<Boolean>? = null

    private var timeZone: Output<String>? = null

    private var winRM: Output<WinRMConfigurationArgs>? = null

    /**
     * @param value Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("aaaaqynvktaevvrn")
    public suspend
    fun additionalUnattendContent(`value`: Output<List<AdditionalUnattendContentArgs>>) {
        this.additionalUnattendContent = value
    }

    @JvmName("lulfcveldmawnwbx")
    public suspend fun additionalUnattendContent(
        vararg
        values: Output<AdditionalUnattendContentArgs>,
    ) {
        this.additionalUnattendContent = Output.all(values.asList())
    }

    /**
     * @param values Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("easeawmepkxhsose")
    public suspend
    fun additionalUnattendContent(values: List<Output<AdditionalUnattendContentArgs>>) {
        this.additionalUnattendContent = Output.all(values)
    }

    /**
     * @param value Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
     */
    @JvmName("vhhvrnsuxsmbghbr")
    public suspend fun enableAutomaticUpdates(`value`: Output<Boolean>) {
        this.enableAutomaticUpdates = value
    }

    /**
     * @param value Indicates whether VMAgent Platform Updates is enabled for the Windows virtual machine. Default value is false.
     */
    @JvmName("gafvhmqnrunyowtk")
    public suspend fun enableVMAgentPlatformUpdates(`value`: Output<Boolean>) {
        this.enableVMAgentPlatformUpdates = value
    }

    /**
     * @param value [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
     */
    @JvmName("lbchibpjumpmhuia")
    public suspend fun patchSettings(`value`: Output<PatchSettingsArgs>) {
        this.patchSettings = value
    }

    /**
     * @param value Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, it is set to true by default. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
     */
    @JvmName("kyayywsjrdsnyjcr")
    public suspend fun provisionVMAgent(`value`: Output<Boolean>) {
        this.provisionVMAgent = value
    }

    /**
     * @param value Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". Possible values can be [TimeZoneInfo&#46;Id](https://docs&#46;microsoft&#46;com/dotnet/api/system&#46;timezoneinfo&#46;id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo&#46;GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
     */
    @JvmName("kxgtayuiqctocyjo")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
     */
    @JvmName("ygihuroewpjeleux")
    public suspend fun winRM(`value`: Output<WinRMConfigurationArgs>) {
        this.winRM = value
    }

    /**
     * @param value Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("loekwuwyjfcxwjrl")
    public suspend fun additionalUnattendContent(`value`: List<AdditionalUnattendContentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalUnattendContent = mapped
    }

    /**
     * @param argument Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("ewypxownlqrjalhe")
    public suspend
    fun additionalUnattendContent(argument: List<suspend AdditionalUnattendContentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AdditionalUnattendContentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalUnattendContent = mapped
    }

    /**
     * @param argument Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("asmgiteeccuhgcdj")
    public suspend fun additionalUnattendContent(
        vararg
        argument: suspend AdditionalUnattendContentArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AdditionalUnattendContentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalUnattendContent = mapped
    }

    /**
     * @param argument Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("ghmjknguhvmxyvby")
    public suspend
    fun additionalUnattendContent(argument: suspend AdditionalUnattendContentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AdditionalUnattendContentArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalUnattendContent = mapped
    }

    /**
     * @param values Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
     */
    @JvmName("wurtgyhnsobiwbvj")
    public suspend fun additionalUnattendContent(vararg values: AdditionalUnattendContentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalUnattendContent = mapped
    }

    /**
     * @param value Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
     */
    @JvmName("hfgttfumdkpvgpdy")
    public suspend fun enableAutomaticUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpdates = mapped
    }

    /**
     * @param value Indicates whether VMAgent Platform Updates is enabled for the Windows virtual machine. Default value is false.
     */
    @JvmName("khtsqkkoenruqqrm")
    public suspend fun enableVMAgentPlatformUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVMAgentPlatformUpdates = mapped
    }

    /**
     * @param value [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
     */
    @JvmName("kwgqhqehwiwblatn")
    public suspend fun patchSettings(`value`: PatchSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchSettings = mapped
    }

    /**
     * @param argument [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
     */
    @JvmName("daiekyicqqohxspq")
    public suspend fun patchSettings(argument: suspend PatchSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PatchSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.patchSettings = mapped
    }

    /**
     * @param value Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, it is set to true by default. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
     */
    @JvmName("kpgatiqfunhammrw")
    public suspend fun provisionVMAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMAgent = mapped
    }

    /**
     * @param value Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". Possible values can be [TimeZoneInfo&#46;Id](https://docs&#46;microsoft&#46;com/dotnet/api/system&#46;timezoneinfo&#46;id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo&#46;GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
     */
    @JvmName("xxtqylfrcntotjtc")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
     */
    @JvmName("qrnpdujkycvptgwn")
    public suspend fun winRM(`value`: WinRMConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.winRM = mapped
    }

    /**
     * @param argument Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
     */
    @JvmName("imixhuiuvrnnvyxo")
    public suspend fun winRM(argument: suspend WinRMConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WinRMConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.winRM = mapped
    }

    internal fun build(): WindowsConfigurationArgs = WindowsConfigurationArgs(
        additionalUnattendContent = additionalUnattendContent,
        enableAutomaticUpdates = enableAutomaticUpdates,
        enableVMAgentPlatformUpdates = enableVMAgentPlatformUpdates,
        patchSettings = patchSettings,
        provisionVMAgent = provisionVMAgent,
        timeZone = timeZone,
        winRM = winRM,
    )
}
