@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
 * @property enabled Whether boot diagnostics should be enabled on the Virtual Machine.
 * @property storageUri Uri of the storage account to use for placing the console output and screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
 */
public data class BootDiagnosticsResponse(
    public val enabled: Boolean? = null,
    public val storageUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.BootDiagnosticsResponse):
            BootDiagnosticsResponse = BootDiagnosticsResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            storageUri = javaType.storageUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
