@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a capacity reservation that includes the name of the capacity reservation. It is used for the response to the instance view of a capacity reservation group.
 * @property name The name of the capacity reservation.
 * @property statuses The resource status information.
 * @property utilizationInfo Unutilized capacity of the capacity reservation.
 */
public data class CapacityReservationInstanceViewWithNameResponse(
    public val name: String,
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val utilizationInfo: CapacityReservationUtilizationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CapacityReservationInstanceViewWithNameResponse):
            CapacityReservationInstanceViewWithNameResponse =
            CapacityReservationInstanceViewWithNameResponse(
                name = javaType.name(),
                statuses = javaType.statuses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                    })
                }),
                utilizationInfo = javaType.utilizationInfo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationUtilizationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
