@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Extension Properties.
 * @property autoUpgradeMinorVersion Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
 * @property forceUpdateTag Tag to force apply the provided public and protected settings.
 * Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
 * If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
 * If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
 * it is up to handler implementation whether to re-run it or not
 * @property protectedSettings Protected settings for the extension which are encrypted before sent to the role instance.
 * @property protectedSettingsFromKeyVault Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property publisher The name of the extension handler publisher.
 * @property rolesAppliedTo Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
 * @property settings Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
 * @property type Specifies the type of the extension.
 * @property typeHandlerVersion Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
 */
public data class CloudServiceExtensionPropertiesResponse(
    public val autoUpgradeMinorVersion: Boolean? = null,
    public val forceUpdateTag: String? = null,
    public val protectedSettings: Any? = null,
    public val protectedSettingsFromKeyVault: CloudServiceVaultAndSecretReferenceResponse? = null,
    public val provisioningState: String,
    public val publisher: String? = null,
    public val rolesAppliedTo: List<String>? = null,
    public val settings: Any? = null,
    public val type: String? = null,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceExtensionPropertiesResponse):
            CloudServiceExtensionPropertiesResponse = CloudServiceExtensionPropertiesResponse(
            autoUpgradeMinorVersion = javaType.autoUpgradeMinorVersion().map({ args0 -> args0 }).orElse(null),
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            protectedSettings = javaType.protectedSettings().map({ args0 -> args0 }).orElse(null),
            protectedSettingsFromKeyVault = javaType.protectedSettingsFromKeyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceVaultAndSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            rolesAppliedTo = javaType.rolesAppliedTo().map({ args0 -> args0 }),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
