@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Cloud service properties
 * @property allowModelOverride (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
 * The default value is `false`.
 * @property configuration Specifies the XML service configuration (.cscfg) for the cloud service.
 * @property configurationUrl Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
 * This is a write-only property and is not returned in GET calls.
 * @property extensionProfile Describes a cloud service extension profile.
 * @property networkProfile Network Profile for the cloud service.
 * @property osProfile Describes the OS profile for the cloud service.
 * @property packageUrl Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
 * This is a write-only property and is not returned in GET calls.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property roleProfile Describes the role profile for the cloud service.
 * @property startCloudService (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
 * If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
 * @property uniqueId The unique identifier for the cloud service.
 * @property upgradeMode Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
 * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
 * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
 */
public data class CloudServicePropertiesResponse(
    public val allowModelOverride: Boolean? = null,
    public val configuration: String? = null,
    public val configurationUrl: String? = null,
    public val extensionProfile: CloudServiceExtensionProfileResponse? = null,
    public val networkProfile: CloudServiceNetworkProfileResponse? = null,
    public val osProfile: CloudServiceOsProfileResponse? = null,
    public val packageUrl: String? = null,
    public val provisioningState: String,
    public val roleProfile: CloudServiceRoleProfileResponse? = null,
    public val startCloudService: Boolean? = null,
    public val uniqueId: String,
    public val upgradeMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServicePropertiesResponse):
            CloudServicePropertiesResponse = CloudServicePropertiesResponse(
            allowModelOverride = javaType.allowModelOverride().map({ args0 -> args0 }).orElse(null),
            configuration = javaType.configuration().map({ args0 -> args0 }).orElse(null),
            configurationUrl = javaType.configurationUrl().map({ args0 -> args0 }).orElse(null),
            extensionProfile = javaType.extensionProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceExtensionProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceNetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceOsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            packageUrl = javaType.packageUrl().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            roleProfile = javaType.roleProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceRoleProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startCloudService = javaType.startCloudService().map({ args0 -> args0 }).orElse(null),
            uniqueId = javaType.uniqueId(),
            upgradeMode = javaType.upgradeMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
