@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of a dedicated host that includes the name of the dedicated host. It is used for the response to the instance view of a dedicated host group.
 * @property assetId Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
 * @property availableCapacity Unutilized capacity of the dedicated host.
 * @property name The name of the dedicated host.
 * @property statuses The resource status information.
 */
public data class DedicatedHostInstanceViewWithNameResponse(
    public val assetId: String,
    public val availableCapacity: DedicatedHostAvailableCapacityResponse? = null,
    public val name: String,
    public val statuses: List<InstanceViewStatusResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DedicatedHostInstanceViewWithNameResponse):
            DedicatedHostInstanceViewWithNameResponse = DedicatedHostInstanceViewWithNameResponse(
            assetId = javaType.assetId(),
            availableCapacity = javaType.availableCapacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostAvailableCapacityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
