@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Describes a Encryption Settings for a Disk
 * @property diskEncryptionKey Specifies the location of the disk encryption key, which is a Key Vault Secret.
 * @property enabled Specifies whether disk encryption should be enabled on the virtual machine.
 * @property keyEncryptionKey Specifies the location of the key encryption key in Key Vault.
 */
public data class DiskEncryptionSettingsResponse(
    public val diskEncryptionKey: KeyVaultSecretReferenceResponse? = null,
    public val enabled: Boolean? = null,
    public val keyEncryptionKey: KeyVaultKeyReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskEncryptionSettingsResponse):
            DiskEncryptionSettingsResponse = DiskEncryptionSettingsResponse(
            diskEncryptionKey = javaType.diskEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            keyEncryptionKey = javaType.keyEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultKeyReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
