@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 * @property dataDiskImages A list of encryption specifications for data disk images.
 * @property osDiskImage Contains encryption settings for an OS disk image.
 */
public data class EncryptionImagesResponse(
    public val dataDiskImages: List<DataDiskImageEncryptionResponse>? = null,
    public val osDiskImage: OSDiskImageEncryptionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.EncryptionImagesResponse):
            EncryptionImagesResponse = EncryptionImagesResponse(
            dataDiskImages = javaType.dataDiskImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DataDiskImageEncryptionResponse.Companion.toKotlin(args0)
                })
            }),
            osDiskImage = javaType.osDiskImage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.OSDiskImageEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
