@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The source for the disk image.
 * @property id The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
 * @property storageAccountId The Storage Account Id that contains the vhd blob being used as a source for this artifact version.
 * @property uri The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
 */
public data class GalleryDiskImageSourceResponse(
    public val id: String? = null,
    public val storageAccountId: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryDiskImageSourceResponse):
            GalleryDiskImageSourceResponse = GalleryDiskImageSourceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
