@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes the cloud service.
 * @property id Resource Id.
 * @property location Resource location.
 * @property name Resource name.
 * @property properties Cloud service properties
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zones List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
 */
public data class GetCloudServiceResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: CloudServicePropertiesResponse,
    public val systemData: SystemDataResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetCloudServiceResult):
            GetCloudServiceResult = GetCloudServiceResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.CloudServicePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
