@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the gallery image definition that you want to create or update.
 * @property architecture The architecture of the image. Applicable to OS disks only.
 * @property description The description of this gallery image definition resource. This property is updatable.
 * @property disallowed Describes the disallowed disk types.
 * @property endOfLifeDate The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
 * @property eula The Eula agreement for the gallery image definition.
 * @property features A list of gallery image features.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
 * @property id Resource Id
 * @property identifier This is the gallery image definition identifier.
 * @property location Resource location
 * @property name Resource name
 * @property osState This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'.
 * @property osType This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
 * @property privacyStatementUri The privacy statement uri.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property purchasePlan Describes the gallery image definition purchase plan. This is used by marketplace images.
 * @property recommended The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
 * @property releaseNoteUri The release note uri.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetGalleryImageResult(
    public val architecture: String? = null,
    public val description: String? = null,
    public val disallowed: DisallowedResponse? = null,
    public val endOfLifeDate: String? = null,
    public val eula: String? = null,
    public val features: List<GalleryImageFeatureResponse>? = null,
    public val hyperVGeneration: String? = null,
    public val id: String,
    public val identifier: GalleryImageIdentifierResponse,
    public val location: String,
    public val name: String,
    public val osState: String,
    public val osType: String,
    public val privacyStatementUri: String? = null,
    public val provisioningState: String,
    public val purchasePlan: ImagePurchasePlanResponse? = null,
    public val recommended: RecommendedMachineConfigurationResponse? = null,
    public val releaseNoteUri: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetGalleryImageResult):
            GetGalleryImageResult = GetGalleryImageResult(
            architecture = javaType.architecture().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            disallowed = javaType.disallowed().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DisallowedResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endOfLifeDate = javaType.endOfLifeDate().map({ args0 -> args0 }).orElse(null),
            eula = javaType.eula().map({ args0 -> args0 }).orElse(null),
            features = javaType.features().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageFeatureResponse.Companion.toKotlin(args0)
                })
            }),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identifier = javaType.identifier().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageIdentifierResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            osState = javaType.osState(),
            osType = javaType.osType(),
            privacyStatementUri = javaType.privacyStatementUri().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            purchasePlan = javaType.purchasePlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImagePurchasePlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recommended = javaType.recommended().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RecommendedMachineConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            releaseNoteUri = javaType.releaseNoteUri().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
