@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a virtual machine scale set virtual machine.
 * @property additionalCapabilities Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
 * @property availabilitySet Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
 * @property diagnosticsProfile Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property hardwareProfile Specifies the hardware settings for the virtual machine.
 * @property id Resource Id
 * @property identity The identity of the virtual machine, if configured.
 * @property instanceId The virtual machine instance ID.
 * @property instanceView The virtual machine instance view.
 * @property latestModelApplied Specifies whether the latest model has been applied to the virtual machine.
 * @property licenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
 * @property location Resource location
 * @property modelDefinitionApplied Specifies whether the model applied to the virtual machine is the model of the virtual machine scale set or the customized model for the virtual machine.
 * @property name Resource name
 * @property networkProfile Specifies the network interfaces of the virtual machine.
 * @property networkProfileConfiguration Specifies the network profile configuration of the virtual machine.
 * @property osProfile Specifies the operating system settings for the virtual machine.
 * @property plan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property protectionPolicy Specifies the protection policy of the virtual machine.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property resources The virtual machine child extension resources.
 * @property securityProfile Specifies the Security related profile settings for the virtual machine.
 * @property sku The virtual machine SKU.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property tags Resource tags
 * @property type Resource type
 * @property userData UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
 * @property vmId Azure VM unique ID.
 * @property zones The virtual machine zones.
 */
public data class GetVirtualMachineScaleSetVMResult(
    public val additionalCapabilities: AdditionalCapabilitiesResponse? = null,
    public val availabilitySet: SubResourceResponse? = null,
    public val diagnosticsProfile: DiagnosticsProfileResponse? = null,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val id: String,
    public val identity: VirtualMachineIdentityResponse? = null,
    public val instanceId: String,
    public val instanceView: VirtualMachineScaleSetVMInstanceViewResponse,
    public val latestModelApplied: Boolean,
    public val licenseType: String? = null,
    public val location: String,
    public val modelDefinitionApplied: String,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val networkProfileConfiguration:
    VirtualMachineScaleSetVMNetworkProfileConfigurationResponse? = null,
    public val osProfile: OSProfileResponse? = null,
    public val plan: PlanResponse? = null,
    public val protectionPolicy: VirtualMachineScaleSetVMProtectionPolicyResponse? = null,
    public val provisioningState: String,
    public val resources: List<VirtualMachineExtensionResponse>,
    public val securityProfile: SecurityProfileResponse? = null,
    public val sku: SkuResponse,
    public val storageProfile: StorageProfileResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userData: String? = null,
    public val vmId: String,
    public val zones: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetVirtualMachineScaleSetVMResult):
            GetVirtualMachineScaleSetVMResult = GetVirtualMachineScaleSetVMResult(
            additionalCapabilities = javaType.additionalCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilitySet = javaType.availabilitySet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diagnosticsProfile = javaType.diagnosticsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceId = javaType.instanceId(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMInstanceViewResponse.Companion.toKotlin(args0)
            }),
            latestModelApplied = javaType.latestModelApplied(),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            modelDefinitionApplied = javaType.modelDefinitionApplied(),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkProfileConfiguration = javaType.networkProfileConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMNetworkProfileConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protectionPolicy = javaType.protectionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetVMProtectionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userData = javaType.userData().map({ args0 -> args0 }).orElse(null),
            vmId = javaType.vmId(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
