@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a storage profile.
 * @property dataDisks Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property osDisk Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property zoneResilient Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
 */
public data class ImageStorageProfileResponse(
    public val dataDisks: List<ImageDataDiskResponse>? = null,
    public val osDisk: ImageOSDiskResponse? = null,
    public val zoneResilient: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ImageStorageProfileResponse):
            ImageStorageProfileResponse = ImageStorageProfileResponse(
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImageDataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            osDisk = javaType.osDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ImageOSDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zoneResilient = javaType.zoneResilient().map({ args0 -> args0 }).orElse(null),
        )
    }
}
