@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
 * @property keyUrl Url pointing to a key or secret in KeyVault
 * @property sourceVault Resource id of the KeyVault containing the key or secret
 */
public data class KeyVaultAndKeyReferenceResponse(
    public val keyUrl: String,
    public val sourceVault: SourceVaultResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.KeyVaultAndKeyReferenceResponse):
            KeyVaultAndKeyReferenceResponse = KeyVaultAndKeyReferenceResponse(
            keyUrl = javaType.keyUrl(),
            sourceVault = javaType.sourceVault().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SourceVaultResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
