@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of the last installed patch summary.
 * @property error The errors that were encountered during execution of the operation. The details array contains the list of them.
 * @property excludedPatchCount The number of all available patches but excluded explicitly by a customer-specified exclusion list match.
 * @property failedPatchCount The count of patches that failed installation.
 * @property installationActivityId The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
 * @property installedPatchCount The count of patches that successfully installed.
 * @property lastModifiedTime The UTC timestamp when the operation began.
 * @property maintenanceWindowExceeded Describes whether the operation ran out of time before it completed all its intended actions
 * @property notSelectedPatchCount The number of all available patches but not going to be installed because it didn't match a classification or inclusion list entry.
 * @property pendingPatchCount The number of all available patches expected to be installed over the course of the patch installation operation.
 * @property startTime The UTC timestamp when the operation began.
 * @property status The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings."
 */
public data class LastPatchInstallationSummaryResponse(
    public val error: ApiErrorResponse,
    public val excludedPatchCount: Int,
    public val failedPatchCount: Int,
    public val installationActivityId: String,
    public val installedPatchCount: Int,
    public val lastModifiedTime: String,
    public val maintenanceWindowExceeded: Boolean,
    public val notSelectedPatchCount: Int,
    public val pendingPatchCount: Int,
    public val startTime: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.LastPatchInstallationSummaryResponse):
            LastPatchInstallationSummaryResponse = LastPatchInstallationSummaryResponse(
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.ApiErrorResponse.Companion.toKotlin(args0)
            }),
            excludedPatchCount = javaType.excludedPatchCount(),
            failedPatchCount = javaType.failedPatchCount(),
            installationActivityId = javaType.installationActivityId(),
            installedPatchCount = javaType.installedPatchCount(),
            lastModifiedTime = javaType.lastModifiedTime(),
            maintenanceWindowExceeded = javaType.maintenanceWindowExceeded(),
            notSelectedPatchCount = javaType.notSelectedPatchCount(),
            pendingPatchCount = javaType.pendingPatchCount(),
            startTime = javaType.startTime(),
            status = javaType.status(),
        )
    }
}
