@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains security profile for an OS disk image.
 * @property confidentialVMEncryptionType confidential VM encryption types
 * @property secureVMDiskEncryptionSetId secure VM disk encryption set id
 */
public data class OSDiskImageSecurityProfileResponse(
    public val confidentialVMEncryptionType: String? = null,
    public val secureVMDiskEncryptionSetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.OSDiskImageSecurityProfileResponse):
            OSDiskImageSecurityProfileResponse = OSDiskImageSecurityProfileResponse(
            confidentialVMEncryptionType = javaType.confidentialVMEncryptionType().map({ args0 ->
                args0
            }).orElse(null),
            secureVMDiskEncryptionSetId = javaType.secureVMDiskEncryptionSetId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
