@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A policy violation reported against a gallery artifact.
 * @property category Describes the nature of the policy violation.
 * @property details Describes specific details about why this policy violation was reported.
 */
public data class PolicyViolationResponse(
    public val category: String? = null,
    public val details: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.PolicyViolationResponse):
            PolicyViolationResponse = PolicyViolationResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 -> args0 }).orElse(null),
        )
    }
}
