@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * This is the regional replication status.
 * @property details The details of the replication status.
 * @property progress It indicates progress of the replication job.
 * @property region The region to which the gallery image version is being replicated to.
 * @property state This is the regional replication state.
 */
public data class RegionalReplicationStatusResponse(
    public val details: String,
    public val progress: Int,
    public val region: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RegionalReplicationStatusResponse):
            RegionalReplicationStatusResponse = RegionalReplicationStatusResponse(
            details = javaType.details(),
            progress = javaType.progress(),
            region = javaType.region(),
            state = javaType.state(),
        )
    }
}
