@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of the Virtual Machine for which the restore point was created. The properties provided are a subset and the snapshot of the overall Virtual Machine properties captured at the time of the restore point creation.
 * @property diagnosticsProfile Gets the diagnostics profile.
 * @property hardwareProfile Gets the hardware profile.
 * @property hyperVGeneration HyperVGeneration of the source VM for which restore point is captured.
 * @property licenseType Gets the license type, which is for bring your own license scenario.
 * @property location Location of the VM from which the restore point was created.
 * @property osProfile Gets the OS profile.
 * @property securityProfile Gets the security profile.
 * @property storageProfile Gets the storage profile.
 * @property userData UserData associated with the source VM for which restore point is captured, which is a base-64 encoded value.
 * @property vmId Gets the virtual machine unique id.
 */
public data class RestorePointSourceMetadataResponse(
    public val diagnosticsProfile: DiagnosticsProfileResponse,
    public val hardwareProfile: HardwareProfileResponse,
    public val hyperVGeneration: String,
    public val licenseType: String,
    public val location: String,
    public val osProfile: OSProfileResponse,
    public val securityProfile: SecurityProfileResponse,
    public val storageProfile: RestorePointSourceVMStorageProfileResponse? = null,
    public val userData: String,
    public val vmId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.RestorePointSourceMetadataResponse):
            RestorePointSourceMetadataResponse = RestorePointSourceMetadataResponse(
            diagnosticsProfile = javaType.diagnosticsProfile().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse.Companion.toKotlin(args0)
            }),
            hardwareProfile = javaType.hardwareProfile().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
            }),
            hyperVGeneration = javaType.hyperVGeneration(),
            licenseType = javaType.licenseType(),
            location = javaType.location(),
            osProfile = javaType.osProfile().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse.Companion.toKotlin(args0)
            }),
            securityProfile = javaType.securityProfile().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
            }),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointSourceVMStorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userData = javaType.userData(),
            vmId = javaType.vmId(),
        )
    }
}
