@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the required information to reference a compute gallery application version
 * @property configurationReference Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided
 * @property enableAutomaticUpgrade If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated for the VM/VMSS
 * @property order Optional, Specifies the order in which the packages have to be installed
 * @property packageReferenceId Specifies the GalleryApplicationVersion resource id on the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
 * @property tags Optional, Specifies a passthrough value for more generic context.
 * @property treatFailureAsDeploymentFailure Optional, If true, any failure for any operation in the VmApplication will fail the deployment
 */
public data class VMGalleryApplicationResponse(
    public val configurationReference: String? = null,
    public val enableAutomaticUpgrade: Boolean? = null,
    public val order: Int? = null,
    public val packageReferenceId: String,
    public val tags: String? = null,
    public val treatFailureAsDeploymentFailure: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VMGalleryApplicationResponse):
            VMGalleryApplicationResponse = VMGalleryApplicationResponse(
            configurationReference = javaType.configurationReference().map({ args0 -> args0 }).orElse(null),
            enableAutomaticUpgrade = javaType.enableAutomaticUpgrade().map({ args0 -> args0 }).orElse(null),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            packageReferenceId = javaType.packageReferenceId(),
            tags = javaType.tags().map({ args0 -> args0 }).orElse(null),
            treatFailureAsDeploymentFailure = javaType.treatFailureAsDeploymentFailure().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
