@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the script sources for run command. Use only one of script, scriptUri, commandId.
 * @property commandId Specifies a commandId of predefined built-in script.
 * @property script Specifies the script content to be executed on the VM.
 * @property scriptUri Specifies the script download location. It can be either SAS URI of an Azure storage blob with read access or public URI.
 * @property scriptUriManagedIdentity User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
 */
public data class VirtualMachineRunCommandScriptSourceResponse(
    public val commandId: String? = null,
    public val script: String? = null,
    public val scriptUri: String? = null,
    public val scriptUriManagedIdentity: RunCommandManagedIdentityResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineRunCommandScriptSourceResponse):
            VirtualMachineRunCommandScriptSourceResponse = VirtualMachineRunCommandScriptSourceResponse(
            commandId = javaType.commandId().map({ args0 -> args0 }).orElse(null),
            script = javaType.script().map({ args0 -> args0 }).orElse(null),
            scriptUri = javaType.scriptUri().map({ args0 -> args0 }).orElse(null),
            scriptUriManagedIdentity = javaType.scriptUriManagedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RunCommandManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
