@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 * @property dnsServers List of DNS servers IP addresses
 */
public data class VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse(
    public val dnsServers: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse):
            VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse =
            VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse(
                dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            )
    }
}
