@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin

import com.pulumi.azurenative.confidentialledger.kotlin.outputs.ManagedCCFPropertiesResponse
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.ManagedCCFPropertiesResponse.Companion.toKotlin as managedCCFPropertiesResponseToKotlin
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedCCF].
 */
@PulumiTagMarker
public class ManagedCCFResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedCCFArgs = ManagedCCFArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedCCFArgsBuilder.() -> Unit) {
        val builder = ManagedCCFArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedCCF {
        val builtJavaResource =
            com.pulumi.azurenative.confidentialledger.ManagedCCF(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedCCF(builtJavaResource)
    }
}

/**
 * Managed CCF. Contains the properties of Managed CCF Resource.
 * Azure REST API version: 2023-01-26-preview.
 * Other available API versions: 2023-06-28-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:confidentialledger:ManagedCCF DummyLedgerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/managedCCFs/{appName}
 * ```
 */
public class ManagedCCF internal constructor(
    override val javaResource: com.pulumi.azurenative.confidentialledger.ManagedCCF,
) : KotlinCustomResource(javaResource, ManagedCCFMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Managed CCF Resource.
     */
    public val properties: Output<ManagedCCFPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                managedCCFPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedCCFMapper : ResourceMapper<ManagedCCF> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.confidentialledger.ManagedCCF::class == javaResource::class

    override fun map(javaResource: Resource): ManagedCCF = ManagedCCF(
        javaResource as
            com.pulumi.azurenative.confidentialledger.ManagedCCF,
    )
}

/**
 * @see [ManagedCCF].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedCCF].
 */
public suspend fun managedCCF(name: String, block: suspend ManagedCCFResourceBuilder.() -> Unit):
    ManagedCCF {
    val builder = ManagedCCFResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedCCF].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedCCF(name: String): ManagedCCF {
    val builder = ManagedCCFResourceBuilder()
    builder.name(name)
    return builder.build()
}
