@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin

import com.pulumi.azurenative.confidentialledger.ManagedCCFArgs.builder
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.ManagedCCFPropertiesArgs
import com.pulumi.azurenative.confidentialledger.kotlin.inputs.ManagedCCFPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Managed CCF. Contains the properties of Managed CCF Resource.
 * Azure REST API version: 2023-01-26-preview.
 * Other available API versions: 2023-06-28-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:confidentialledger:ManagedCCF DummyLedgerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/managedCCFs/{appName}
 * ```
 * @property appName Name of the Managed CCF
 * @property location The geo-location where the resource lives
 * @property properties Properties of Managed CCF Resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ManagedCCFArgs(
    public val appName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ManagedCCFPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.ManagedCCFArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.ManagedCCFArgs =
        com.pulumi.azurenative.confidentialledger.ManagedCCFArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedCCFArgs].
 */
@PulumiTagMarker
public class ManagedCCFArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ManagedCCFPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Managed CCF
     */
    @JvmName("tgvyulvkdiochome")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("npfnrivqtlfoqtpv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Managed CCF Resource.
     */
    @JvmName("dfrtpwybvjwgebto")
    public suspend fun properties(`value`: Output<ManagedCCFPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("isfteitaxsjgkkwt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("okficrxufhdbsmft")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Managed CCF
     */
    @JvmName("oxklyqsnbminvunn")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lcjbjqqqnbcjwpdl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Managed CCF Resource.
     */
    @JvmName("myvbjnbqekwatmcr")
    public suspend fun properties(`value`: ManagedCCFPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Managed CCF Resource.
     */
    @JvmName("gurivghteuhohdlq")
    public suspend fun properties(argument: suspend ManagedCCFPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedCCFPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vqyekkshdxbvuilt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gwlnoawcvgdkjcmt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vtjdexmvllsnbevg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedCCFArgs = ManagedCCFArgs(
        appName = appName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
